<?php

namespace App\Http\Controllers;

use DateTime;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Offer;
use App\Models\Skill;
use App\Models\Course;
use App\Models\Worker;
use App\Models\Service;
use App\Models\Setting;
use App\Models\Student;
use App\Models\Teacher;
use App\Models\Customer;
use App\Models\Enrollment;
use App\Models\ReneHistory;
use Illuminate\Http\Request;
use App\Mail\SendReminderEmail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class EnrolController extends Controller
{
    public function index()
    {

        $workers = Worker::where('current_status', 4)->get();
        $customers = Customer::all();

        if (!Auth::check()) {

            return redirect()->route('login_page')->with('error', trans('messages.please_log_in', [], session('locale')));
        }

        $user = Auth::user();

        if (in_array(3, explode(',', $user->permit_type))) {

            return view('enroll.enroll', compact('workers', 'customers'));
        } else {

            return redirect()->route('/')->with('error', trans('messages.you_dont_have_permissions', [], session('locale')));
        }
    }




    public function show_subscription(Request $request)
    {


        $sno = 0;
        $view_subscription = Enrollment::where('worker_status', '!=', 4)
            ->orderBy('created_at', 'desc')
            ->get();
        if (count($view_subscription) > 0) {
            foreach ($view_subscription as $value) {

                $worker = Worker::where('id', $value->worker_id)->value('worker_name');
                $customer = Customer::where('id', $value->customer_id)->value('customer_name');


                $costly = '';

                // Ensure we are checking properly for available values
                if ($value->trail_cost !== null && $value->trail_cost !== '') {
                    // If years is set, use it
                    $costly = $value->trail_cost;
                } elseif ($value->years_salary !== null && $value->years_salary !== '') {
                    // If neither years nor months are set but days is, use it
                    $costly = $value->years_salary;
                }

                // If there's no period, assign a default message
                if (empty($costly)) {
                    $costly = trans('messages.no_cost', [], session('locale'));
                }
                $worker_name = '<a href="' . url('worker_profile/' . $value->worker_id) . '">' . $worker . '</a>';

                $status = '';
                if ($value->worker_status == 1) {
                    $status = 'Trial';
                } elseif ($value->worker_status == 2) {
                    $status = 'Yearly';
                } elseif ($value->worker_status == 3) {
                    $status = 'Monthly';
                } else {
                    $status = 'None';
                }

                $modal = '

                <a href="' . url('edit_subscription', ['id' => $value->id]) . '" class="btn btn-outline-secondary btn-sm" title="Edit">
            <i class="fas fa-pencil-alt" style="color: blue;" title="Edit"></i>
          </a>
          <a class="btn btn-outline-secondary btn-sm" title="Delete" onclick=del("' . $value->id . '")>
          <i class="fas fa-trash" style="color: red;" title="Delete"></i>
          </a>';

                if ($value->worker_status == 1) {
                    $modal .= '
          <a class="btn btn-outline-secondary btn-sm"
                data-bs-toggle="modal"
                data-bs-target="#add_retrun_modal"
                data-value1="' . $worker . '"
                data-value7="' . $value->worker_id . '"
                data-value8="' . $value->customer_id . '"
                data-value2="' . $customer . '"
                data-value3="' . $value->deployment_date . '"
                data-value6="' . $status . '"
                data-value4="' . $costly . '"
                data-value5="' . $value->id . '">

                <i class="fas fa-calendar" style="color: orange;"  title="Renew"></i>
                </a>';
                }


                $add_data = \Carbon\Carbon::parse($value->created_at)->format('d-m-Y (h:iA)');
                $customer_name =  Customer::where('id', $value->customer_id)->value('customer_name');
                $status = '';

                if ($value->worker_status == 1) {
                    $status = trans('messages.on_trail_lang', [], session('locale')); // Translation for "On Trail"
                    $badgeClass = 'bg-primary';  // Blue badge for "On Trail"
                } elseif ($value->worker_status == 2) {
                    $status = trans('messages.years2_lang', [], session('locale')); // Translation for "Years"
                    $badgeClass = 'bg-warning';  // Yellow badge for "Years"
                } elseif ($value->worker_status == 3) {
                    $status = trans('messages.months2_lang', [], session('locale')); // Translation for "Months"
                    $badgeClass = 'bg-info';  // Blue badge for "Months"
                } elseif ($value->worker_status == 4) {
                    $status = trans('messages.available_lang', [], session('locale')); // Translation for "Available"
                    $badgeClass = 'bg-success';  // Green badge for "Available"
                } else {
                    $status = trans('messages.unknown_status_lang', [], session('locale')); // Translation for "Unknown Status"
                    $badgeClass = 'bg-danger';  // Red badge for "Unknown Status"
                }



                $deploy_date = Carbon::parse($value->deployment_date);
                $trail_days = (int) $value->trail_days;  // Cast to integer
                $months = (int) $value->months;          // Cast to integer
                $years = (int) $value->duration_years;   // Cast to integer

                // Get current date
                $current_date = Carbon::now();

                // Initialize the remaining period variable
                $remaining_period = null;

                // Calculate end date based on deployment duration
                $end_date = $deploy_date->copy();

                if ($years) {
                    $end_date->addYears($years);
                } elseif ($months) {
                    $end_date->addMonths($months);
                } elseif ($trail_days) {
                    $end_date->addDays($trail_days);
                }

                // Calculate the remaining period
                $remaining_days = $current_date->diffInDays($end_date);
                $remaining_months = $current_date->diffInMonths($end_date);
                $remaining_years = $current_date->diffInYears($end_date);

                // Round the remaining years, months, or days to a whole number
                $remaining_years = round($remaining_years);
                $remaining_months = round($remaining_months);
                $remaining_days = round($remaining_days);

                // Check remaining period and display accordingly
                if ($remaining_days < 0) {
                    // If the remaining time is negative, that means the worker is already available
                    $remaining_period = trans('messages.available', [], session('locale'));
                } else {
                    // Ensure we only show one unit of time
                    if ($remaining_years > 0) {
                        $remaining_period = $remaining_years . ' ' . trans('messages.years_remaining', [], session('locale'));
                    } elseif ($remaining_months > 0) {
                        $remaining_period = $remaining_months . ' ' . trans('messages.months_remaining', [], session('locale'));
                    } elseif ($remaining_days > 0) {
                        $remaining_period = $remaining_days . ' ' . trans('messages.days_remaining', [], session('locale'));
                    }

                    // If it's less than 1 day, show "Available"
                    if ($remaining_days < 1) {
                        $remaining_period = trans('messages.available', [], session('locale'));
                    }
                }

                // Show the end date (when the worker will be available)
                $availability_date = $end_date->format('Y-m-d'); // You can adjust the format as needed

                // If no duration is set (e.g., no `trail_days`, `months`, or `years`), show no remaining period
                if (!$years && !$months && !$trail_days) {
                    $remaining_period = trans('messages.no_remaining_period', [], session('locale'));
                }



                $period = '';

                // Ensure we are checking properly for available values
                if ($value->duration_years !== null && $value->duration_years !== '') {
                    // If years is set, use it
                    $period = $value->duration_years . ' ' . trans('messages.years', [], session('locale'));
                } elseif ($value->months !== null && $value->months !== '') {
                    // If years is not set but months is, use it
                    $period = $value->months . ' ' . trans('messages.months', [], session('locale'));
                } elseif ($value->trail_days !== null && $value->trail_days !== '') {
                    // If neither years nor months are set but days is, use it
                    $period = $value->trail_days . ' ' . trans('messages.days', [], session('locale'));
                }

                // If there's no period, assign a default message
                if (empty($period)) {
                    $period = trans('messages.no_duration', [], session('locale'));
                }

                $cost = '';

                // Ensure we are checking properly for available values
                if ($value->trail_cost !== null && $value->trail_cost !== '') {
                    // If years is set, use it
                    $cost = $value->trail_cost;
                } elseif ($value->months_salary !== null && $value->months_salary !== '') {
                    // If years is not set but months_salary is, use it
                    $cost = $value->months_salary;
                } elseif ($value->years_salary !== null && $value->years_salary !== '') {
                    // If neither years nor months are set but days is, use it
                    $cost = $value->years_salary;
                }

                // If there's no period, assign a default message
                if (empty($cost)) {
                    $cost = trans('messages.no_cost', [], session('locale'));
                }



                $sno++;
                $json[] = array(
                    $sno,
                    $worker_name,
                    $customer_name,
                    '<span class="badge bg-primary">' . $value->deployment_date . '</span>', // Renewal date

                    $value->skill,

                    '<span class="badge bg-danger"> ' . trans('messages.total_period', [], session('locale')) . ': ' . $period . '</span>' . '<br>' . // Renewal date

                        '<span class="badge bg-success ">' . $remaining_period . '</span>' . '<br>' . // Renewal date
                        '<span class="badge bg-danger">' . trans('messages.available_by', [], session('locale')) . ': ' .  $availability_date . '</span>', // Renewal date

                    '<span class="badge ' . $badgeClass . '">' . $status . '</span>', // Remaining time

                    trans('messages.monthly_charge_rate', [], session('locale')) . ': ' . $value->monthly_rate  . '<br>' .
                        trans('messages.total_amount', [], session('locale')) . ': ' .  $cost,
                    $value->added_by, // Added by
                    $add_data,
                    $modal // Modal or additional action
                );
            }



            $response = array();
            $response['success'] = true;
            $response['aaData'] = $json;
            echo json_encode($response);
        } else {
            $response = array();
            $response['sEcho'] = 0;
            $response['iTotalRecords'] = 0;
            $response['iTotalDisplayRecords'] = 0;
            $response['aaData'] = [];
            echo json_encode($response);
        }
    }






    public function add_subscription(Request $request)
    {


        $user_id = Auth::id();
        $userData = User::find($user_id);
        $user_name = $userData->user_name;

        $services = $request['service_id'];
        $duration = $request['salary_duration'];
        $trail = $request['deployment'];
        $monthly = $request['monthly_deploy'];


        $status = '';

        $status = '';

        if ($duration !== null) {
            $status = 2;
        }

        if ($trail === 'on') {
            $status = 1;
        }

        if ($monthly === 'on') {
            $status = 3;
        }


        if ($status === '') {
            $status = 4;
        }

        $worker = Worker::where('id', $services)->first();
        $worker->current_status = $status;
        $worker->save();

        $enroll = new Enrollment();

        $enroll->worker_id = $services;
        $enroll->customer_id = $request['customer_id'];
        $enroll->trail = $trail;
        $enroll->monthly_rate = $request['salary'];
        $enroll->years_salary = $request['salary_years'];
        $enroll->deployment_date = $request['deploy_date'];

        $enroll->worker_status = $status;
        $enroll->skill = $request['skill'];
        $enroll->duration_years = $duration;
        $enroll->trail_days = $request['days'];
        $enroll->trail_cost = $request['trail_cost'];
        $enroll->months = $request['months'];
        $enroll->months_salary = $request['monthly_salary'];
        $enroll->notes = $request['notes'];
        $enroll->added_by = $user_name;
        $enroll->user_id = $user_id;
        $enroll->save();

        $history = new ReneHistory();
        $history->worker_id = $services;
        $history->deploy_id = $enroll->id;
        $history->customer_id = $request['customer_id'];
        if (!empty($enroll->years_salary) || $enroll->years_salary !== null) {
            $history->employee_earning = $request['salary_years'];
        }

        if (!empty($enroll->trail_cost) || $enroll->trail_cost !== null) {
            $history->employee_earning = $request['trail_cost'];
        }

        $history->trail = $trail;
        $history->years_salary = $request['salary_years'];
        $history->duration_years = $duration;
        $history->deployment_date = $request['deploy_date'];
        $history->worker_status = $status;
        $history->trail_days = $request['days'];
        $history->trail_cost = $request['trail_cost'];
        $history->notes = $request['notes'];
        $history->added_by = $user_name;
        $history->user_id = $user_id;
        $history->save();


        return response()->json(['sub_id' => $enroll->id, 'status' => 1]);
    }
    public function edit_subscription($id, Request $request)
    {
        $sub_id = $id;

        $sub_data = Enrollment::where('id', $sub_id)->first();

        if (!$sub_data) {
            return response()->json(['error' => trans('messages.enroll_not_found', [], session('locale'))], 404);
        }


        $workers = Worker::get();
        $customers = Customer::all();
        // Pass variables directly to the view
        return view('enroll.edit_sub', [
            'sub_data' => $sub_data,
            'workers' => $workers,
            'customers' => $customers, // Parsed as an array
        ]);
    }




    public function update_subscription(Request $request)
    {
        // Get the authenticated user's ID and details
        $user_id = Auth::id();
        $userData = User::find($user_id);
        $user_name = $userData->user_name;

        $sub_id = $request->input('deploy_id');

        $services = $request['service_id'];
        $duration = $request['salary_duration'];
        $trail = $request['deployment'];
        $monthly = $request['monthly_deploy'];
        $status = '';

        $status = '';

        if ($duration !== null) {
            $status = 2;
        }

        if ($trail === 'on') {
            $status = 1;
        }

        if ($monthly === 'on') {
            $status = 3;
        }


        if ($status === '') {
            $status = 4;
        }

        $worker = Worker::where('id', $services)->first();
        $worker->current_status = $status;
        $worker->save();

        $enroll = Enrollment::where('id', $sub_id)->first();

        $enroll->worker_id = $services;
        $enroll->customer_id = $request['customer_id'];
        $enroll->trail = $trail;
        $enroll->monthly_rate = $request['salary'];
        $enroll->years_salary = $request['salary_years'];
        $enroll->deployment_date = $request['deploy_date'];

        $enroll->worker_status = $status;
        $enroll->skill = $request['skill'];
        $enroll->duration_years = $duration;
        $enroll->trail_days = $request['days'];
        $enroll->trail_cost = $request['trail_cost'];
        $enroll->months = $request['months'];
        $enroll->months_salary = $request['monthly_salary'];
        $enroll->notes = $request['notes'];
        $enroll->added_by = $user_name;
        $enroll->user_id = $user_id;
        $enroll->save();

        $history = ReneHistory::where('deploy_id', $sub_id)->first();
        $history->worker_id = $services;
        $history->deploy_id = $enroll->id;

        $history->customer_id = $request['customer_id'];
        if (!empty($enroll->years_salary) || $enroll->years_salary !== null) {
            $history->employee_earning = $request['salary_years'];
        }

        if (!empty($enroll->trail_cost) || $enroll->trail_cost !== null) {
            $history->employee_earning = $request['trail_cost'];
        }
        $history->trail = $trail;
        $history->years_salary = $request['salary_years'];
        $history->duration_years = $duration;
        $history->deployment_date = $request['deploy_date'];
        $history->worker_status = $status;
        $history->trail_days = $request['days'];
        $history->trail_cost = $request['trail_cost'];
        $history->notes = $request['notes'];
        $history->updated_by = $user_name;
        $history->user_id = $user_id;
        $history->save();
        return response()->json(['enroll_id' => $enroll->id, 'status' => 1]);
    }


    public function delete_subscription(Request $request)
    {
        $enroll_id = $request->input('id');
        $enroll = Enrollment::where('id', $enroll_id)->first();

        $worker = Worker::where('id', $enroll->worker_id)->first();
        $worker->current_status = 4;
        $worker->save();
        if (!$enroll) {
            return response()->json(['error' => trans('messages.subscription_not_found', [], session('locale'))], 404);
        }
        $enroll->delete();
        return response()->json([
            'success' => trans('messages.subscription_deleted_lang', [], session('locale'))
        ]);
    }



    public function add_customer2(Request $request)
    {


        $user_id = Auth::id();
        $data = User::find($user_id)->first();
        $user = $data->user_name;

        $customer = new Customer();




        $customer->customer_name = $request['customer_name'];
        $customer->customer_number = $request['customer_number'];
        $customer->customer_email = $request['customer_email'];

        $customer->address = $request['address'];
        $customer->added_by = $user;
        $customer->user_id =  $user_id;
        $customer->save();
        // customer add sms
        // $params = [
        //     'customer_id' => $customer->id,
        //     'sms_status' => 1
        // ];
        // $sms = get_sms($params);
        // sms_module($request['customer_phone'], $sms);

        //
        return response()->json(['customer_id' => $customer->id, 'customer_name' => $customer->customer_name, 'status' => 1]);
    }

    public function all_sub()
    {
        return view('enroll.all_sub');
    }



    public function add_renewl(Request $request)
    {


        $id = $request->input('renewl_id');
        $worker_id = $request->input('worker_id');
        $trail = $request['deployment'];
        $returnDate = Carbon::parse($request->input('return_date'));
        $employeeRate = $request->input('employee_rate');


        $worker = Worker::where('id', $worker_id)->first();
        $deployement = Enrollment::where('id', $id)->first();

        if ($trail === 'on') {
            $worker->current_status = 2;
            $deployement->worker_status = 2;
            $deployement->duration_years = 2;
            $deployement->years_salary = $employeeRate;
            $deployement->trail_cost = null;
            $deployement->trail_days = null;
            $deployement->trail_days = null;
        } else {
            $worker->current_status = 4;
            $deployement->worker_status = 4;
            $deployement->trail_days = null;
            $deployement->deployment_date = now()->format('Y-m-d');
        }

        $worker->save();
        $deployement->save();

        $history = new ReneHistory();

        $deployDate = Carbon::parse($request->input('deploy_date'));


        // Ensure the return date is after the deploy date
        if ($deployDate->gt($returnDate)) {
            return response()->json([
                'status' => 2,
            ], 400); // Use HTTP status 400 (Bad Request)
        }

        // Calculate the period
        $periodInDays = $deployDate->diffInDays($returnDate);
        $periodInMonths = $deployDate->diffInMonths($returnDate);
        $periodInYears = $deployDate->diffInYears($returnDate);

        // Ensure the period is not less than one
        if ($periodInDays < 1) {
            $periodInDays = 0;
        }

        if ($periodInMonths < 1) {
            $periodInMonths = 0;
        }

        if ($periodInYears < 1) {
            $periodInYears = 0;
        }



        $history->deploy_id = $id;
        $history->worker_id = $worker_id;
        $history->customer_id = $request->input('customer_id');
        $history->employee_status = $request->input('employee_status');
        $refundAmount = $request->input('refund_amount');
        $employeeEarning = $employeeRate - $refundAmount;

        if ($employeeEarning < 0) {
            $employeeEarning = 0;
        }

        if ($trail === 'on') {

            $history->worker_status = 2;
            $history->duration_years = 2;
            $history->years_salary = $employeeRate;



        }
        if (!is_null($refundAmount) && is_numeric($refundAmount)) {
            $history->worker_status = 4;
        }

        $history->employee_rate = $employeeRate;
        $history->trial_to_years = $trail;
        $history->refund_amount = $refundAmount;
        $history->employee_earning = $employeeEarning;
        $history->deployment_date = $request->input('deploy_date');
        $history->return_date = $request->input('return_date');
        $history->employee_period = "{$periodInYears} years, {$periodInMonths} months, {$periodInDays} days";
        $history->notes = $request->input('notes');

        $history->save();




        return response()->json(['status' => 1]);
    }

    //     public function getServiceCost($id)
    // {
    //     $service = Service::where('id', $id)->first();

    //     if ($service) {
    //         return response()->json([
    //             'status' => true,
    //             'service_cost' => $service->service_cost,
    //         ]);
    //     }

    //     return response()->json([
    //         'status' => false,
    //         'message' => 'Service not found',
    //     ]);
    // }

    public function getWorkerSalary($id)
    {
        $worker = Worker::where('id', $id)->first();
        $skill_id = $worker->skill;
        $skill_name = Skill::where('id', $skill_id)->first();
        $skill = $skill_name->skill_name;

        if ($worker) {
            return response()->json([
                'success' => true,
                'salary' => $worker->salary,
                'skill' => $skill, // Assuming the salary is stored in the 'salary' column
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => trans('messages.worker_not_found', [], session('locale'))
        ]);
    }

    public function getSalary(Request $request)
    {
        $workerId = $request->get('worker_id');
        $worker = Worker::where('id', $workerId)->first();


        if ($worker) {
            return response()->json([
                'salary' => $worker->salary,

            ]);
        }

        return response()->json(['error' => 'Worker not found'], 404);
    }
}
