<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Course;
use App\Models\Worker;
use App\Models\Student;
use App\Models\Teacher;
use App\Models\Enrollment;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Customer;
use Doctrine\Inflector\Rules\Word;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    public function index()
{
    $latest_workers = Worker::latest()->take(10)->get();
    $latest_customers = Customer::latest()->take(10)->get();
    $latest_enrollments = Enrollment::latest()->take(10)->get();

    $one_worker = Worker::latest()->take(1)->get()->value('worker_name');
    $one_customer = Customer::latest()->take(1)->get()->value('customer_name');
    $one_user = User::latest()->take(1)->get()->value('user_name');
    $one_enrollment = Enrollment::latest()->take(1)->get()->value('worker_id');
    $one_enroll = Worker::where('id', $one_enrollment)->value('worker_name');

    $worker_count = Worker::count();
    $customer_count = Customer::count();
    $user_count = User::count();
    $enrollment_count = Enrollment::count();
    $worker_trails = Worker::where('current_status', 1)->count();
    $worker_enganed = Worker::where('current_status', 2)->count();
    $worker_available = Worker::where('current_status', 4)->count();

    if (Auth::check()) {
        return view('dashboard.index', compact(
            'latest_workers',
            'latest_customers',
            'latest_enrollments',
            'one_worker',
            'one_customer',
            'one_user',
            'one_enrollment',
            'one_enroll',
            'customer_count',
            'worker_count',
            'user_count',
            'enrollment_count',
            'worker_trails',
            'worker_enganed',
            'worker_available'
        ));
    } else {
        return redirect()->route('login_page')->with('error', 'Logged In First');
    }
}




    public function switchLanguage($locale)
    {
        app()->setLocale($locale);
        config(['app.locale' => $locale]);
        // You can store the chosen locale in session for persistence
        session(['locale' => $locale]);

        return redirect()->back(); // or any other redirect you want
    }
}
