<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Status;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StatusController extends Controller
{
    public function index(){


        if (!Auth::check()) {

            return redirect()->route('login_page')->with('error', trans('messages.please_log_in', [], session('locale')));
        }

        $user = Auth::user();

        if (in_array(11, explode(',', $user->permit_type))) {

            return view ('worker_status.status');

        } else {


 return redirect()->route('/')->with('error', trans('messages.you_dont_have_permissions', [], session('locale')));
        }

    }

    public function show_status()
    {
        $sno=0;

        $view_status= Status::all();
        if(count($view_status)>0)
        {
            foreach($view_status as $value)
            {





                $modal='<a class="btn btn-outline-secondary btn-sm edit" data-bs-toggle="modal" data-bs-target="#add_status_modal" onclick=edit("'.$value->id.'") title="Edit">
                            <i class="fas fa-pencil-alt" title="Edit"></i>
                        </a>
                        <a class="btn btn-outline-secondary btn-sm edit" onclick=del("'.$value->id.'") title="Delete">
                            <i class="fas fa-trash" title="Edit"></i>
                        </a>';
                $add_data=get_date_only($value->created_at);



                $sno++;
                $json[] = array(
                $sno,
                $value->status_name,
                '<span style="text-align: justify; white-space: pre-line;">' . $value->notes . '</span>',
                $value->added_by,
                $modal
                );



            }
            $response = array();
            $response['success'] = true;
            $response['aaData'] = $json;
            echo json_encode($response);
        }
        else
        {
            $response = array();
            $response['sEcho'] = 0;
            $response['iTotalRecords'] = 0;
            $response['iTotalDisplayRecords'] = 0;
            $response['aaData'] = [];
            echo json_encode($response);
        }
    }

    public function add_status(Request $request)
    {

        $user_id = Auth::id();
        $userData = User::find($user_id);
        $user_name = $userData->user_name;

        $status = new Status();
        $status->status_name = $request['status_name'];
        $status->notes = $request['notes'];
        $status->added_by = $user_name;
        $status->user_id = $user_id;
        $status->save();

        return response()->json(['status_id' => $status->id, 'status' => 1]);
    }


    public function edit_status(Request $request)
    {
        $status_id = $request->input('id');
        $status_data = Status::where('id', $status_id)->first();

        if (!$status_data) {
            return response()->json(['error' => trans('messages.status_not_found', [], session('locale'))], 404);
        }

        $course_ids = !empty($status_data->course_id) ? explode(',', $status_data->course_id) : [];

        $select_option='';



        $data = [
            'status_id' => $status_data->id,
            'status_name' => $status_data->status_name,
            'notes' => $status_data->notes,
        ];

        return response()->json($data);
    }


    public function update_status(Request $request)
    {
        $user_id = Auth::id();
        $userData = User::where('id', $user_id)->first();
        $user_name = $userData->user_name;

        // Find the status by ID
        $status_id = $request->input('status_id');
        $status = Status::where('id', $status_id)->first();
        if (!$status) {
            return response()->json(['error' => trans('messages.status_not_found', [], session('locale'))], 404);
        }

        $status->status_name = $request['status_name'];
        $status->notes = $request['notes'];
        $status->updated_by = $user_name;
        $status->user_id = $user_id;
        $status->save();

        return response()->json(['status_id' => $status->id, 'status' => 1]);
    }


    public function delete_status(Request $request){
        $status_id = $request->input('id');
        $status = Status::where('id', $status_id)->first();
        if (!$status) {
            return response()->json(['error' => trans('messages.status_not_found', [], session('locale'))], 404);
        }
        $status->delete();
        return response()->json([
            'success' => trans('messages.status_deleted_lang', [], session('locale'))
        ]);


    }

    public function status_profile($id){

        $status= Status::where('id', $id)->first();

        return view ('status.status_profile', compact('status'));


    }

}
