<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Skill;
use App\Models\Status;
use App\Models\Worker;
use App\Models\Country;
use App\Models\Enrollment;
use App\Models\ReneHistory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PHPUnit\Framework\Constraint\Count;

class WorkerController extends Controller
{
    public function index(){


        $skills= Skill::all();
        $status= Status::all();
        $countries= Country::all();

        if (!Auth::check()) {

            return redirect()->route('login_page')->with('error', 'Please LogIn first()');
        }

        $user = Auth::user();

        if (in_array(10, explode(',', $user->permit_type))) {

            return view ('worker_status.worker', compact('skills', 'status', 'countries'));

        } else {

            return redirect()->route('home')->with( 'error', 'You dont have Permission');
        }

    }

    public function show_worker()
    {
        $sno=0;

        $view_worker= Worker::all();
        if(count($view_worker)>0)
        {
            foreach($view_worker as $value)
            {

                $worker_name='<a href="worker_profile/' . $value->id . '">' . ($value->worker_name) . '</a>';

                $modal='<a class="btn btn-outline-secondary btn-sm edit" data-bs-toggle="modal" data-bs-target="#add_worker_modal" onclick=edit("'.$value->id.'") title="Edit">
                            <i class="fas fa-pencil-alt" title="Edit"></i>
                        </a>
                        <a class="btn btn-outline-secondary btn-sm edit" onclick=del("'.$value->id.'") title="Delete">
                            <i class="fas fa-trash" title="Edit"></i>
                        </a>';
                $add_data=get_date_only($value->created_at);

                $skill= Skill::where('id', $value->skill)->value('skill_name');
                $country= Country::where('id', $value->nationality)->value('name');
                $status = '';

                if ($value->current_status == 1) {
                    $status = trans('messages.on_trail_lang', [], session('locale')); // Translation for "On Trail"
                    $badgeClass = 'bg-primary';  // Blue badge for "On Trail"
                } elseif ($value->current_status == 2) {
                    $status = trans('messages.years2_lang', [], session('locale')); // Translation for "Years"
                    $badgeClass = 'bg-warning';  // Yellow badge for "Years"
                } elseif ($value->current_status == 3) {
                    $status = trans('messages.months2_lang', [], session('locale')); // Translation for "Months"
                    $badgeClass = 'bg-info';  // Blue badge for "Months"
                } elseif ($value->current_status == 4) {
                    $status = trans('messages.available_lang', [], session('locale')); // Translation for "Available"
                    $badgeClass = 'bg-success';  // Green badge for "Available"
                } else {
                    $status = trans('messages.unknown_status_lang', [], session('locale')); // Translation for "Unknown Status"
                    $badgeClass = 'bg-danger';  // Red badge for "Unknown Status"
                }

                $sno++;
                $json[] = array(
                    $sno,
                   $worker_name,
                   $value->worker_number,
                    $country,
                    '<span class="badge ' . $badgeClass . ' fs-6">' . $status . '</span>',  // Badge for status
                    trans('messages.age', [], session('locale')) . ': ' . $value->age . '<br>' . trans('messages.salary', [], session('locale')) . ': ' . $value->salary,
                    $skill,
                    '<span>' . trans('messages.added_by', [], session('locale')) . ': ' . $value->added_by . '</span><br>' .
                    '<span>' . trans('messages.added_on', [], session('locale')) . ': ' . $add_data . '</span>',
                    $modal
                );

            }
            $response = array();
            $response['success'] = true;
            $response['aaData'] = $json;
            echo json_encode($response);
        }
        else
        {
            $response = array();
            $response['sEcho'] = 0;
            $response['iTotalRecords'] = 0;
            $response['iTotalDisplayRecords'] = 0;
            $response['aaData'] = [];
            echo json_encode($response);
        }
    }

    public function add_worker(Request $request){


        $user_id = Auth::id();
        $data= User::find( $user_id)->first();
        $user= $data->user_name;

        $worker = new Worker();

        $worker->worker_name = $request['worker_name'];
        $worker->worker_number = $request['worker_number'];
        $worker->skill = $request['skill'];
        $worker->salary = $request['salary'];
        $worker->nationality = $request['nationality'];
        $worker->current_status = $request['current_status'];
        $worker->age = $request['worker_age'];
        $worker->notes = $request['notes'];
        $worker->added_by = $user;
        $worker->user_id =  $user_id;
        $worker->save();

        return response()->json(['worker_id' => $worker->id , 'status' => 1]);

    }

    public function edit_worker(Request $request){
        $worker = new worker();
        $worker_id = $request->input('id');

        // Use the Eloquent where method to retrieve the worker by column name
        $worker_data = Worker::where('id', $worker_id)->first();

        if (!$worker_data) {
            return response()->json(['error' => trans('messages.worker_not_found', [], session('locale'))], 404);
        }


        $data = [
            'worker_id' => $worker_data->id,
            'worker_name' =>   $worker_data->worker_name,
            'salary' =>   $worker_data->salary,
            'age' =>   $worker_data->age,
            'skill' =>  $worker_data->skill,
            'worker_number' => $worker_data->worker_number,
            'nationality' =>  $worker_data->nationality,
            'current_status' => $worker_data->current_status,
            'notes' => $worker_data->notes,


        ];

        return response()->json($data);
    }

    public function update_worker(Request $request){


        $user_id = Auth::id();
        $data= User::find( $user_id)->first();
        $user= $data->user_name;

        $worker_id = $request->input('worker_id');
        $worker = Worker::where('id', $worker_id)->first();
        if (!$worker) {
            return response()->json(['error' => trans('messages.worker_not_found', [], session('locale'))], 404);
        }



        $worker->worker_name = $request['worker_name'];
        $worker->worker_number = $request['worker_number'];
        $worker->skill = $request['skill'];
        $worker->salary = $request['salary'];

        $worker->nationality = $request['nationality'];
        $worker->current_status = $request['current_status'];
        $worker->age = $request['worker_age'];
        $worker->notes = $request['notes'];
        $worker->updated_by = $user;
        $worker->save();
        return response()->json(['worker_id' => '', 'status' => 1]);
    }

    public function delete_worker(Request $request){
        $worker_id = $request->input('id');
        $worker = Worker::where('id', $worker_id)->first();
        if (!$worker) {
            return response()->json(['error' => trans('messages.worker_not_found', [], session('locale'))], 404);
        }
        $worker->delete();
        return response()->json([
            'success' => trans('messages.worker_deleted_lang', [], session('locale'))
        ]);


    }




    public function worker_profile($id)
    {
        $worker = Worker::where('id', $id)->first();

        $value = Enrollment::where('worker_id', $worker->id)
        ->where('worker_status', '!=', 4)
        ->first();


        $status = '';

                if ($value->worker_status == 1) {
                    $status = trans('messages.on_trail_lang', [], session('locale')); // Translation for "On Trail"
                    $badgeClass = 'bg-primary';  // Blue badge for "On Trail"
                } elseif ($value->worker_status == 2) {
                    $status = trans('messages.years2_lang', [], session('locale')); // Translation for "Years"
                    $badgeClass = 'bg-warning';  // Yellow badge for "Years"
                } elseif ($value->worker_status == 3) {
                    $status = trans('messages.months2_lang', [], session('locale')); // Translation for "Months"
                    $badgeClass = 'bg-info';  // Blue badge for "Months"
                } elseif ($value->worker_status == 4) {
                    $status = trans('messages.available_lang', [], session('locale')); // Translation for "Available"
                    $badgeClass = 'bg-success';  // Green badge for "Available"
                } else {
                    $status = trans('messages.unknown_status_lang', [], session('locale')); // Translation for "Unknown Status"
                    $badgeClass = 'bg-danger';  // Red badge for "Unknown Status"
                }



                $deploy_date = Carbon::parse($value->deployment_date);
                $trail_days = (int) $value->trail_days;  // Cast to integer
                $months = (int) $value->months;          // Cast to integer
                $years = (int) $value->duration_years;   // Cast to integer

                // Get current date
                $current_date = Carbon::now();

                // Initialize the remaining period variable
                $remaining_period = null;

                // Calculate end date based on deployment duration
                $end_date = $deploy_date->copy();

                if ($years) {
                    $end_date->addYears($years);
                } elseif ($months) {
                    $end_date->addMonths($months);
                } elseif ($trail_days) {
                    $end_date->addDays($trail_days);
                }

                // Calculate the remaining period
                $remaining_days = $current_date->diffInDays($end_date);
                $remaining_months = $current_date->diffInMonths($end_date);
                $remaining_years = $current_date->diffInYears($end_date);

                // Round the remaining years, months, or days to a whole number
                $remaining_years = round($remaining_years);
                $remaining_months = round($remaining_months);
                $remaining_days = round($remaining_days);

                // Check remaining period and display accordingly
                if ($remaining_days < 0) {
                    // If the remaining time is negative, that means the worker is already available
                    $remaining_period = trans('messages.available', [], session('locale'));
                } else {
                    // Ensure we only show one unit of time
                    if ($remaining_years > 0) {
                        $remaining_period = $remaining_years . ' ' . trans('messages.years_remaining', [], session('locale'));
                    } elseif ($remaining_months > 0) {
                        $remaining_period = $remaining_months . ' ' . trans('messages.months_remaining', [], session('locale'));
                    } elseif ($remaining_days > 0) {
                        $remaining_period = $remaining_days . ' ' . trans('messages.days_remaining', [], session('locale'));
                    }

                    // If it's less than 1 day, show "Available"
                    if ($remaining_days < 1) {
                        $remaining_period = trans('messages.available', [], session('locale'));
                    }
                }

                // Show the end date (when the worker will be available)
                $availability_date = $end_date->format('Y-m-d'); // You can adjust the format as needed

                // If no duration is set (e.g., no `trail_days`, `months`, or `years`), show no remaining period
                if (!$years && !$months && !$trail_days) {
                    $remaining_period = trans('messages.no_remaining_period', [], session('locale'));
                }



                $period = '';

                // Ensure we are checking properly for available values
                if ($value->duration_years !== null && $value->duration_years !== '') {
                    // If years is set, use it
                    $period = $value->duration_years . ' ' . trans('messages.years', [], session('locale'));
                } elseif ($value->months !== null && $value->months !== '') {
                    // If years is not set but months is, use it
                    $period = $value->months . ' ' . trans('messages.months', [], session('locale'));
                } elseif ($value->trail_days !== null && $value->trail_days !== '') {
                    // If neither years nor months are set but days is, use it
                    $period = $value->trail_days . ' ' . trans('messages.days', [], session('locale'));
                }

                // If there's no period, assign a default message
                if (empty($period)) {
                    $period = trans('messages.no_duration', [], session('locale'));
                }

                $cost = '';

                // Ensure we are checking properly for available values
                if ($value->trail_cost !== null && $value->trail_cost !== '') {
                    // If years is set, use it
                    $cost = $value->trail_cost;
                } elseif ($value->months_salary !== null && $value->months_salary !== '') {
                    // If years is not set but months_salary is, use it
                    $cost = $value->months_salary;
                } elseif ($value->years_salary !== null && $value->years_salary !== '') {
                    // If neither years nor months are set but days is, use it
                    $cost = $value->years_salary;
                }

                // If there's no period, assign a default message
                if (empty($cost)) {
                    $cost = trans('messages.no_cost', [], session('locale'));
                }

                $badgeData = '<span class="badge bg-danger"> ' . trans('messages.total_period', [], session('locale')) . ': ' . $period . '</span>' . '<br>' .
             '<span class="badge bg-success ">' . $remaining_period . '</span>' . '<br>' .
             '<span class="badge bg-danger">' . trans('messages.available_by', [], session('locale')) . ': ' .  $availability_date . '</span>' . '<br>' .
             '<span class="badge ' . $badgeClass . '">' . $status . '</span>';


             $history = ReneHistory::where('worker_id', $id)
             ->where('worker_status', '!=', 4)
             ->get();

        return view('worker_status.worker_profile', compact('worker', 'value', 'badgeData', 'cost', 'history'));
    }
}
