<script>

   $(document).ready(function() {

    $('#all_subscription').DataTable({
    "sAjaxSource": "{{ url('show_subscription') }}",
    "bFilter": true,
    "pagingType": "numbers",
    "ordering": true,
    "order": [[8, "desc"]],
});






$('#add_retrun_modal').off().on('submit', function(e) {
    e.preventDefault();

    // Prepare form data
    var formdatas = new FormData($('.add_renewl')[0]);
    var date = $('.new_renewl_date').val();


    // Check if the service or student is not selected
    if (date === "") {
        show_notification('error', '<?php echo trans('messages.add_new_renewl_date_lang', [], session('locale')); ?>');
        return false;
    }



    // Show loader before submitting
    $('#global-loader').show();
    before_submit(); // Call any pre-submit actions if needed

    var csrfToken = $('meta[name="csrf-token"]').attr('content');


    $.ajax({
        type: "POST",

        url: "{{ url('add_renewl') }}",
        data: formdatas,
        contentType: false,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': csrfToken // Include CSRF token in headers
        },
        success: function(data) {
            // Hide loader and call post-submit actions
            $('#global-loader').hide();
            after_submit();

            if (data.status == 1) {
                    show_notification('success', '<?php echo trans('messages.data_add_success_lang', [], session('locale')); ?>');
                    $('#add_retrun_modal').modal('hide');
                    $('#all_subscription').DataTable().ajax.reload();
                } else if (response.status == 2) {
                    show_notification('error', '<?php echo trans('messages.return_date_cant_exceed_lang', [], session('locale')); ?>');
                }
            else {
                // Handle other statuses or errors in the response
                show_notification('error', data.message || '<?php echo trans('messages.data_add_failed_lang', [], session('locale')); ?>');
                $('#all_subscription').DataTable().ajax.reload();

            }
        },
        error: function(data) {
            // Hide loader and call post-submit actions
            $('#global-loader').hide();
            after_submit();

            show_notification('error', '<?php echo trans('messages.data_add_failed_lang', [], session('locale')); ?>');

        }
    });

});



$('#add_retrun_modal').on('show.bs.modal', function (event) {
    // Get data from the button that triggered the modal
    var button = $(event.relatedTarget);  // Button that triggered the modal
    var value1 = button.data('value1');  // Extract the value1
    var value2 = button.data('value2');  // Extract the value2

    var value3 = button.data('value3');  // Extract the value1
    var value4 = button.data('value4');  // Extract the value1
    var value5 = button.data('value5');  // Extract the value1
    var value6 = button.data('value6');  // Extract the value1
    var value7 = button.data('value7');  // Extract the value1
    var value8 = button.data('value8');  // Extract the value1

    var modal = $(this);
    modal.find('#worker_name').val(value1);  // Set Value 1
    modal.find('#customer_name').val(value2);  // Set Value 2
    modal.find('#renewl_id').val(value5);  // Set Value 1
    modal.find('#deploy_date').val(value3);  // Set Value 1
    modal.find('#employee_rate').val(value4);  // Set Value 2
    modal.find('#employee_status').val(value6);  // Set Value 2
    modal.find('#worker_id').val(value7);  // Set Value 2
    modal.find('#customer_id').val(value8);  // Set Value 2

});


});
function del(id) {
        Swal.fire({
            title:  '<?php echo trans('messages.sure_lang',[],session('locale')); ?>',
            text:  '<?php echo trans('messages.delete_lang',[],session('locale')); ?>',
            type: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: '<?php echo trans('messages.delete_it_lang',[],session('locale')); ?>',
            confirmButtonClass: "btn btn-primary",
            cancelButtonClass: "btn btn-danger ml-1",
            buttonsStyling: !1
        }).then(function (result) {
            if (result.value) {
                $('#global-loader').show();
                before_submit();
                var csrfToken = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: "{{ url('delete_subscription') }}",
                    type: 'POST',
                    data: {id: id,_token: csrfToken},
                    error: function () {
                        $('#global-loader').hide();
                        after_submit();
                        show_notification('error', '<?php echo trans('messages.delete_failed_lang',[],session('locale')); ?>');
                    },
                    success: function (data) {
                        $('#global-loader').hide();
                        after_submit();
                        $('#all_subscription').DataTable().ajax.reload();
                        show_notification('success', '<?php echo trans('messages.delete_success_lang',[],session('locale')); ?>');
                    }
                });
            } else if (result.dismiss === Swal.DismissReason.cancel) {
                show_notification('success', '<?php echo trans('messages.safe_lang',[],session('locale')); ?>');
            }
        });
    }






    document.addEventListener("DOMContentLoaded", function () {
        const returnSwitch = document.getElementById("return_switch");
        const toggleInputs = document.querySelectorAll(".new_input");

        returnSwitch.addEventListener("change", function () {
            if (this.checked) {
                toggleInputs.forEach(input => input.style.display = "block");
            } else {
                toggleInputs.forEach(input => input.style.display = "none");
            }
        });
    });
    document.addEventListener("DOMContentLoaded", function () {
        const returnSwitch = document.getElementById("deploy_switch");
        const toggleInputs = document.querySelectorAll(".old_input");

        returnSwitch.addEventListener("change", function () {
            if (this.checked) {
                toggleInputs.forEach(input => input.style.display = "block");
            } else {
                toggleInputs.forEach(input => input.style.display = "none");
            }
        });
    });


    document.addEventListener("DOMContentLoaded", function () {
        const deploySwitch = document.getElementById("deploy_switch");
        const returnSwitch = document.getElementById("return_switch");

        deploySwitch.addEventListener("change", function () {
            if (this.checked) {
                returnSwitch.disabled = true; // Disable return switch
            } else {
                returnSwitch.disabled = false; // Enable return switch
            }
        });

        returnSwitch.addEventListener("change", function () {
            if (this.checked) {
                deploySwitch.disabled = true; // Disable deploy switch
            } else {
                deploySwitch.disabled = false; // Enable deploy switch
            }
        });
    });



</script>
