@extends('layouts.header')
@section('main')
    @push('title')
        <title>{{ $report_name ?? '' }}  </title>
    @endpush

<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">{{ trans('messages.reports', [], session('locale')) }}</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">{{ trans('messages.reports', [], session('locale')) }}</a></li>
                                <li class="breadcrumb-item active">{{ trans('messages.worker_income_report', [], session('locale')) }}</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">

                            <form id="incomeReportForm" action="{{ route('employee_income_report') }}" method="post">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-auto">
                                        <div class="d-flex align-items-center gap-4 mb-4">
                                            {{-- <div class="w-100">
                                                <label for="date_from" class="form-label">{{ trans('messages.date_from', [], session('locale')) }} </label>
                                                <input class="form-control datepick" id="date_from" name="date_from" placeholder="{{ trans('messages.from_date', [], session('locale')) }}"
                                                       value="{{ old('date_from', $sdate ?? '') }}">
                                            </div>

                                            <div class="w-100">
                                                <label for="to_date" class="form-label">{{ trans('messages.date_to', [], session('locale')) }} </label>
                                                <input class="form-control datepick" id="to_date" name="to_date" placeholder="{{ trans('messages.to_date', [], session('locale')) }}"
                                                       value="{{ old('date_to', $edate ?? '') }}">
                                            </div> --}}
                                            {{-- <div class="w-100">

                                                <label for="worker_id" class="form-label">{{ trans('messages.worker_id_lang', [], session('locale')) }}</label>
                                                <select class="form-control worker_id" name="worker_id">
                                                    <option value="">{{ trans('messages.choose_lang', [], session('locale')) }}</option>
                                                    @foreach ($workers as $cat)
                                                        <option value="{{ $cat->id }}">{{ $cat->worker_name }}</option>
                                                    @endforeach
                                                </select>

                                            </div> --}}
                                        </div>
                                    </div>
{{--
                                    <div class="row text-center">
                                        <button type="button" class="col-lg-2 btn btn-danger" onclick="setDates('week')">{{ trans('messages.last_week', [], session('locale')) }}</button>
                                        <button type="button" class="col-lg-2 btn btn-info" onclick="setDates('month')">{{ trans('messages.last_month', [], session('locale')) }}</button>
                                        <button type="button" class="col-lg-2 btn btn-warning" onclick="setDates('3months')">{{ trans('messages.last_3_months', [], session('locale')) }}</button>
                                        <button type="button" class="col-lg-2 btn btn-primary" onclick="setDates('6months')">{{ trans('messages.last_6_months', [], session('locale')) }}</button>
                                        <button type="button" class="col-lg-2 btn btn-secondary" onclick="setDates('year')">{{ trans('messages.last_year', [], session('locale')) }}</button>
                                    </div> --}}

                                    {{-- <div class="col-sm">
                                        <div class="mt-4">
                                            <button type="submit" class="btn btn-success waves-effect waves-light">{{ trans('messages.submit', [], session('locale')) }}</button>
                                        </div>
                                    </div> --}}
                                </div>
                            </form>

                            <div class="table-responsive">
                                <table id="example" class="table align-middle dt-responsive table-check nowrap" style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                                    <thead>
                                        <tr class="bg-transparent">
                                            <th style="width: 120px; text-align:center;">{{ trans('messages.employee_name', [], session('locale')) }}</th>

                                            <th style="width: 120px; text-align:center;">{{ trans('messages.total_income', [], session('locale')) }}</th>
                                            <th style="width: 120px; text-align:center;">{{ trans('messages.curent_status', [], session('locale')) }}</th>

                                            <th style="width: 120px; text-align:center;">{{ trans('messages.total_trails', [], session('locale')) }}</th>
                                            <th style="width: 120px; text-align:center;">{{ trans('messages.total_deployments', [], session('locale')) }}</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                    @foreach ($enrolments as $enrol)

                        @php
                           $employee = DB::table('workers')
                                ->where('id', $enrol->worker_id)
                                ->distinct() // This ensures you get only distinct records (though it's redundant with primary key)
                                ->first();

                            $employee_income = DB::table('rene_histories')
                                ->where('worker_id', $enrol->worker_id)
                                ->sum('employee_earning');

                            $employee_name = $employee->worker_name;

                            $current_status= $employee->current_status;
                            $trails = DB::table('rene_histories')
                            ->where('worker_id', $enrol->worker_id)
                            ->where('worker_status', 1)
                            ->count();
                            $years = DB::table('rene_histories')
                            ->where('worker_id', $enrol->worker_id)
                            ->where('worker_status', 2)
                            ->count();
                            $statusText = '';
                            $badgeClass = '';

                            if ($current_status == 1) {
                                $statusText = trans('messages.trail_lang', [], session('locale'));
                                $badgeClass = 'bg-primary';
                            } elseif ($current_status == 2) {
                                $statusText = trans('messages.yearly_engaged_lang', [], session('locale'));
                                $badgeClass = 'bg-success';
                            } elseif ($current_status == 4) {
                                $statusText = trans('messages.available_lang', [], session('locale'));
                                $badgeClass = 'bg-info';
                            } else {
                                $statusText = trans('messages.unknown_lang', [], session('locale'));
                                $badgeClass = 'bg-secondary';
                            }

                        @endphp
                        <tr>
                            <td style="width: 120px; text-align:center;">{{  $employee_name ?? '' }}</td>
                            <td style="width: 120px; text-align:center;">{{ $employee_income  ?? '' }}</td>
                            <td style="width: 120px; text-align:center;"> <span class="badge {{ $badgeClass }}">{{ $statusText }}</span></td>
                            <td style="width: 120px; text-align:center;">
                                <span class="badge bg-warning">{{ $trails ?? '0' }}</span>
                            </td>
                            <td style="width: 120px; text-align:center;">
                                <span class="badge bg-dark">{{ $years ?? '0' }}</span>
                            </td>

                        </tr>

                    @endforeach


                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>

@include('layouts.footer')
@endsection
