<?php $__env->startSection('main'); ?>
    <?php $__env->startPush('title'); ?>
        <title><?php echo e($report_name ?? ''); ?>  </title>
    <?php $__env->stopPush(); ?>

<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('messages.reports', [], session('locale'))); ?></h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e(trans('messages.reports', [], session('locale'))); ?></a></li>
                                <li class="breadcrumb-item active"><?php echo e(trans('messages.worker_income_report', [], session('locale'))); ?></li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">

                            <form id="incomeReportForm" action="<?php echo e(route('employee_income_report')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-sm-auto">
                                        <div class="d-flex align-items-center gap-4 mb-4">
                                            
                                            
                                        </div>
                                    </div>


                                    
                                </div>
                            </form>

                            <div class="table-responsive">
                                <table id="example" class="table align-middle dt-responsive table-check nowrap" style="border-collapse: collapse; border-spacing: 0 8px; width: 100%;">
                                    <thead>
                                        <tr class="bg-transparent">
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.employee_name', [], session('locale'))); ?></th>

                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_income', [], session('locale'))); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.curent_status', [], session('locale'))); ?></th>

                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_trails', [], session('locale'))); ?></th>
                                            <th style="width: 120px; text-align:center;"><?php echo e(trans('messages.total_deployments', [], session('locale'))); ?></th>

                                        </tr>
                                    </thead>
                                    <tbody>
                    <?php $__currentLoopData = $enrolments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php
                           $employee = DB::table('workers')
                                ->where('id', $enrol->worker_id)
                                ->distinct() // This ensures you get only distinct records (though it's redundant with primary key)
                                ->first();

                            $employee_income = DB::table('rene_histories')
                                ->where('worker_id', $enrol->worker_id)
                                ->sum('employee_earning');

                            $employee_name = $employee->worker_name;

                            $current_status= $employee->current_status;
                            $trails = DB::table('rene_histories')
                            ->where('worker_id', $enrol->worker_id)
                            ->where('worker_status', 1)
                            ->count();
                            $years = DB::table('rene_histories')
                            ->where('worker_id', $enrol->worker_id)
                            ->where('worker_status', 2)
                            ->count();
                            $statusText = '';
                            $badgeClass = '';

                            if ($current_status == 1) {
                                $statusText = trans('messages.trail_lang', [], session('locale'));
                                $badgeClass = 'bg-primary';
                            } elseif ($current_status == 2) {
                                $statusText = trans('messages.yearly_engaged_lang', [], session('locale'));
                                $badgeClass = 'bg-success';
                            } elseif ($current_status == 4) {
                                $statusText = trans('messages.available_lang', [], session('locale'));
                                $badgeClass = 'bg-info';
                            } else {
                                $statusText = trans('messages.unknown_lang', [], session('locale'));
                                $badgeClass = 'bg-secondary';
                            }

                        ?>
                        <tr>
                            <td style="width: 120px; text-align:center;"><?php echo e($employee_name ?? ''); ?></td>
                            <td style="width: 120px; text-align:center;"><?php echo e($employee_income  ?? ''); ?></td>
                            <td style="width: 120px; text-align:center;"> <span class="badge <?php echo e($badgeClass); ?>"><?php echo e($statusText); ?></span></td>
                            <td style="width: 120px; text-align:center;">
                                <span class="badge bg-warning"><?php echo e($trails ?? '0'); ?></span>
                            </td>
                            <td style="width: 120px; text-align:center;">
                                <span class="badge bg-dark"><?php echo e($years ?? '0'); ?></span>
                            </td>

                        </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                    <!-- end card -->
                </div>
                <!-- end col -->
            </div>
            <!-- end row -->
        </div> <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

</div>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/user/Desktop/Projects/Sultan_Project/resources/views/reports/employee_icome_report.blade.php ENDPATH**/ ?>