<script>
   var customerChoices = new Choices('#customer_id', {
    searchEnabled: true,
});

    $(document).ready(function() {


        $('.add_customer').off().on('submit', function(e){
            e.preventDefault();
            var formdatas = new FormData($('.add_customer')[0]);
            var title=$('.customer_name').val();
            var number=$('.customer_number').val();

            var id=$('.customer_id').val();


                if(title=="" )
                {
                    show_notification('error','<?php echo trans('messages.add_customer_name_lang',[],session('locale')); ?>'); return false;

                }

                if(number=="" )
                {
                    show_notification('error','<?php echo trans('messages.add_customer_phone_lang',[],session('locale')); ?>'); return false;
                }

                $('#global-loader').show();
                before_submit();
                var str = $(".add_customer").serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(url('add_customer2')); ?>",
                    data: formdatas,
                    contentType: false,
                    processData: false,
                    success: function(data) {
                        $('#global-loader').hide();
                        after_submit();
                        if (data.status == 3) {
                        show_notification('error', '<?php echo trans('messages.customer_number_or_contact_exist_lang', [], session('locale')); ?>');
                        return false;
                        }

                        else if(data.status==1)
                        {
                            show_notification('success','<?php echo trans('messages.data_add_success_lang',[],session('locale')); ?>');
                            $('#add_customer_modal').modal('hide');

                            $(".add_customer")[0].reset();
                            if (customerChoices) {
                             customerChoices.setChoices(
                            [
                                {
                                    value: data.customer_id,
                                    label: data.customer_name, // Adjust this based on your API response
                                    selected: true, // Automatically select the newly added customer
                                },
                            ],
                            'value',
                            'label',
                            true // Reset Choices instance
                        );
                    }

                    return false;
                            location.reload();

                            return false;
                        }
                    },
                    error: function(data)
                    {
                        $('#global-loader').hide();
                        after_submit();
                        show_notification('error','<?php echo trans('messages.data_add_failed_lang',[],session('locale')); ?>');
                        console.log(data);
                        return false;
                    }
                });



        });




        $('.subscription_list').off().on('submit', function(e) {
            e.preventDefault();

            // Prepare form data
            var formdatas = new FormData($('.subscription_list')[0]);
            var service = $('.service_id').val();
            var customer = $('.customer_id').val();
            var id = $('.deploy_id').val(); // Get the subscriptionment ID

            // Check if the service or student is not selected
            if (service === "") {
                show_notification('error', '<?php echo trans('messages.add_worker_name_lang', [], session('locale')); ?>');
                return false;
            }

            if (customer === "") {
                show_notification('error', '<?php echo trans('messages.add_customer_lang', [], session('locale')); ?>');
                return false;
            }

            // Show loader before submitting
            $('#global-loader').show();
            before_submit(); // Call any pre-submit actions if needed

            // Get CSRF token from meta tag
            var csrfToken = $('meta[name="csrf-token"]').attr('content');

            // Determine if this is an update or add operation
            var url = id ? "<?php echo e(url('update_subscription')); ?>" :
            "<?php echo e(url('add_subscription')); ?>"; // Update URL if ID is present
            var type = id ? "POST" : "POST"; // Use PUT for update

            $.ajax({
                type: type,
                url: url,
                data: formdatas,
                contentType: false,
                processData: false,
                headers: {
                    'X-CSRF-TOKEN': csrfToken // Include CSRF token in headers
                },
                success: function(data) {
                    // Hide loader and call post-submit actions
                    $('#global-loader').hide();
                    after_submit();

                    if (data.status == 1) {
                        show_notification('success', '<?php echo trans('messages.data_add_success_lang', [], session('locale')); ?>');


                        // Reset the form after successful submission
                        $(".subscription_list")[0].reset();
                        window.location.href = 'all_sub';

                    } else {
                        // Handle other statuses or errors in the response
                        show_notification('error', data.message || '<?php echo trans('messages.data_add_failed_lang', [], session('locale')); ?>');
                    }
                },
                error: function(data) {
                    // Hide loader and call post-submit actions
                    $('#global-loader').hide();
                    after_submit();

                    // Show error message and reload DataTable
                    show_notification('error', '<?php echo trans('messages.data_add_failed_lang', [], session('locale')); ?>');

                }
            });

            $('.customer_id').select2({
                placeholder: '<?php echo e(trans('messages.choose_lang', [], session('locale'))); ?>', // Placeholder text
                allowClear: true // Allow clearing the selection
            });
            $('.service_id').select2({
                placeholder: '<?php echo e(trans('messages.choose_lang', [], session('locale'))); ?>', // Placeholder text
                allowClear: true // Allow clearing the selection
            });
        });


    });

    document.addEventListener('DOMContentLoaded', function () {
    const deploySwitch = document.getElementById('deploy_switch');
    const trailSwitch = document.getElementById('trail_switch');
    const deploymentFields = document.getElementById('deployment_fields');
    const trailFields = document.getElementById('trail_fields');
    const serviceId = document.getElementById('service_id'); // Assuming you have this field for service_id

    // Function to show an alert if service_id is empty
    function validateServiceId() {
        if (serviceId.value.trim() === '') {
            show_notification('error', '<?php echo trans('messages.select_worker_lang', [], session('locale')); ?>'); // Show alert if service_id is empty
            return false;
        }
        return true;
    }

    // Deploy switch change event
    deploySwitch.addEventListener('change', function () {
        if (validateServiceId()) { // Check if service_id is not empty
            if (deploySwitch.checked) {
                trailFields.style.display = 'block';
            } else {
                trailFields.style.display = 'none';
            }
        } else {
            deploySwitch.checked = false; // Uncheck the switch if service_id is empty
        }
    });

    // Trail switch change event
    trailSwitch.addEventListener('change', function () {
        if (validateServiceId()) { // Check if service_id is not empty
            if (trailSwitch.checked) {
                deploymentFields.style.display = 'block';
            } else {
                deploymentFields.style.display = 'none';
            }
        } else {
            trailSwitch.checked = false; // Uncheck the switch if service_id is empty
        }
    });
});




    document.addEventListener('DOMContentLoaded', function () {
    // Initialize Choices for service_id
    const serviceElement = document.getElementById('service_id');
    if (serviceElement) {
        new Choices(serviceElement, {
            searchEnabled: true,
            itemSelectText: '',
        });
    }

    // Initialize Choices for customer_id
    const customerElement = document.getElementById('customer_id'); // Fixed ID
    if (customerElement) {
        new Choices(customerElement, {
            searchEnabled: true,
            itemSelectText: '',
        });
    }
});




$(document).ready(function () {
        $('#service_id').on('change', function () {
            const workerId = $(this).val();

            if (workerId) {
                $.ajax({
                    url: `/get-worker-salary/${workerId}`,
                    type: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            $('#salary').val(response.salary);
                            $('#skill').val(response.skill);

                        } else {
                            show_notification('error', '<?php echo trans('messages.data_failed_lang', [], session('locale')); ?>');
                            $('#salary').val('');
                            $('#skill').val('');


                        }
                    },
                    error: function (xhr, status, error) {
                        console.error('Error:', error);
                        show_notification('error', '<?php echo trans('messages.data_add_failed_lang', [], session('locale')); ?>');
                        $('#salary').val('');
                        $('#skill').val('');

                    }
                });
            } else {
                $('#salary').val('');
            }
        });



    $('#days').on('input', function() {
        // Get the worker ID (assuming you're using a worker select dropdown)
        let workerId = $('#service_id').val(); // Assuming this is where the worker ID is selected

        // Get the number of days entered
        let days = $(this).val();

        if (workerId && days) {
            // Make an AJAX request to get the salary from the server
            $.ajax({
                url: '/get-salary', // Your endpoint to fetch salary
                type: 'GET',
                data: {
                    worker_id: workerId // Send the selected worker ID
                },
                success: function(response) {
                    if (response.salary) {
                        // Assuming monthly salary is returned from the server
                        let monthlySalary = response.salary;

                        // Calculate the trail cost based on the number of days
                        let dailyRate = monthlySalary / 30; // Assuming a month has 30 days
                        let trailCost = dailyRate * days;

                        // Populate the trail_cost input field
                        $('#trail_cost').val(trailCost.toFixed(2)); // Show the cost with two decimal points
                    }
                }
            });
        }
    });
});

document.addEventListener('DOMContentLoaded', function() {
    // Select the elements
    const salaryInput = document.getElementById('salary');
    const oneYearCheckbox = document.getElementById('one_year');
    const twoYearsCheckbox = document.getElementById('two_years');
    const salaryField = document.getElementById('salary_field');
    const salaryYearsInput = document.getElementById('salary_years');

    // Function to validate if the salary input is not empty
    function validateSalaryInput() {
        if (salaryInput.value.trim() === '') {
            show_notification('error', '<?php echo trans('messages.add_salary_lang', [], session('locale')); ?>');
            return false; // Prevent the checkbox from being selected if salary is empty
        }
        return true;
    }

    // Function to update the salary field based on the checkbox selection
    function updateSalary() {
        // Get the value from the salary input field
        let salary = parseFloat(salaryInput.value) || 0;

        // Reset the salary years field
        salaryYearsInput.value = '';

        // Hide the salary field initially
        salaryField.style.display = 'none';

        // Check if "One Year" is selected
        if (oneYearCheckbox.checked) {
            salaryField.style.display = 'block'; // Show the field
            salaryYearsInput.value = (salary * 12).toFixed(2); // Display the yearly salary
        }

        // Check if "Two Years" is selected
        if (twoYearsCheckbox.checked) {
            salaryField.style.display = 'block'; // Show the field
            salaryYearsInput.value = (salary * 24).toFixed(2); // Display the salary for two years
        }

        // If no checkbox is selected, hide the salary field
        if (!oneYearCheckbox.checked && !twoYearsCheckbox.checked) {
            salaryField.style.display = 'none'; // Hide the field
        }
    }

    // Function to ensure only one checkbox is checked at a time
    function handleCheckboxChange() {
        if (!validateSalaryInput()) {
            // If the salary input is empty, prevent checking the checkbox
            oneYearCheckbox.checked = false;
            twoYearsCheckbox.checked = false;
            return;
        }

        if (oneYearCheckbox.checked && twoYearsCheckbox.checked) {
            // Prevent both checkboxes from being checked
            oneYearCheckbox.checked = false;
            twoYearsCheckbox.checked = false;
        } else if (oneYearCheckbox.checked) {
            // Uncheck "Two Years" if "One Year" is selected
            twoYearsCheckbox.checked = false;
        } else if (twoYearsCheckbox.checked) {
            // Uncheck "One Year" if "Two Years" is selected
            oneYearCheckbox.checked = false;
        }

        updateSalary(); // Update the salary after checkbox change
    }

    // Event listeners to trigger the calculation and display logic
    salaryInput.addEventListener('input', updateSalary); // When the salary input changes
    oneYearCheckbox.addEventListener('change', handleCheckboxChange); // When "One Year" checkbox is toggled
    twoYearsCheckbox.addEventListener('change', handleCheckboxChange); // When "Two Years" checkbox is toggled
});







document.addEventListener("DOMContentLoaded", function () {
        const monthSwitch = document.getElementById("month_switch");
        const monthFields = document.getElementById("month_fields");
        const monthsInput = document.getElementById("months");
        const monthlySalaryInput = document.getElementById("monthly_salary");
        const baseSalaryInput = document.getElementById("salary"); // ID for the base salary input
        const serviceId = document.getElementById("service_id"); // ID for the service_id input

        monthSwitch.addEventListener("change", function () {
            if (monthSwitch.checked) {
                if (!serviceId.value) {
                    show_notification('error', '<?php echo trans('messages.add_worker_lang', [], session('locale')); ?>');
                    monthSwitch.checked = false;
                    return;
                }
                monthFields.style.display = "block";
            } else {
                monthFields.style.display = "none";
                monthsInput.value = "";
                monthlySalaryInput.value = "";
            }
        });

        monthsInput.addEventListener("input", function () {
            const months = parseInt(monthsInput.value, 10);
            const baseSalary = parseFloat(baseSalaryInput.value);

            if (isNaN(months) || months <= 0) {
                show_notification('error', '<?php echo trans('messages.enter_valid_number_lang', [], session('locale')); ?>');
                monthsInput.value = "";
                monthlySalaryInput.value = "";
                return;
            }

            if (months > 24) {
                show_notification('error', '<?php echo trans('messages.cannot_exceed_24months_lang', [], session('locale')); ?>');
                monthsInput.value = "";
                monthlySalaryInput.value = "";
                return;
            }

            if (!isNaN(baseSalary)) {
                const totalSalary = months * baseSalary;
                monthlySalaryInput.value = totalSalary.toFixed(2);
            } else {
                show_notification('error', '<?php echo trans('messages.add_salary_lang', [], session('locale')); ?>');
                monthsInput.value = "";
                monthlySalaryInput.value = "";
            }
        });
    });





    document.addEventListener("DOMContentLoaded", function () {
    const checkboxes = document.querySelectorAll("input[name='salary_duration']");
    const deploySwitch = document.getElementById("deploy_switch");

    function disableOthers(except) {
        checkboxes.forEach(checkbox => {
            if (checkbox !== except) checkbox.disabled = true;
        });
        if (deploySwitch !== except) deploySwitch.disabled = true;
    }

    function enableAll() {
        checkboxes.forEach(checkbox => (checkbox.disabled = false));
        deploySwitch.disabled = false;
    }

    function hideAssociatedData() {
        $('#trail_fields').hide();

    }

    checkboxes.forEach(checkbox => {
        checkbox.addEventListener("change", function () {
            if (checkbox.checked) {

                hideAssociatedData();

                if (deploySwitch.checked) {
                    show_notification('error', '<?php echo trans('messages.you_can_Select_one_switch', [], session('locale')); ?>');
                    checkbox.checked = false;
                } else {
                    disableOthers(checkbox);
                }
            } else {
                enableAll();
            }
        });
    });


    deploySwitch.addEventListener("change", function () {

        if (deploySwitch.checked) {
            if (Array.from(checkboxes).some(checkbox => checkbox.checked)) {
                show_notification('error', '<?php echo trans('messages.you_can_Select_one_switch', [], session('locale')); ?>');
                deploySwitch.checked = false;
            } else {
                disableOthers(deploySwitch);
            }
        } else {
            enableAll();
        }
    });
});




</script>
<?php /**PATH /home/user/Desktop/Projects/Sultan_Project/resources/views/custom_js/enroll_js.blade.php ENDPATH**/ ?>